import json

class TargetQueue:
    def __init__(self, filepath):
        self.filepath = filepath
        self.load()

    def load(self):
        with open(self.filepath, 'r') as f:
            self.targets = json.load(f)

    def get_targets(self):
        return self.targets

    def get_next(self):
        if self.targets:
            return self.targets.pop(0)
        return None

    def save(self):
        with open(self.filepath, 'w') as f:
            json.dump(self.targets, f, indent=2)
