import json

class LoginManager:
    def __init__(self, filepath):
        self.filepath = filepath
        self.load()

    def load(self):
        with open(self.filepath, 'r') as f:
            self.accounts = json.load(f)

    def get_accounts(self):
        return self.accounts

    def get_next_account(self):
        for acc in self.accounts:
            if not acc.get("used"):
                return acc
        return None

    def mark_used(self, account):
        for acc in self.accounts:
            if acc['username'] == account['username']:
                acc['used'] = True
        with open(self.filepath, 'w') as f:
            json.dump(self.accounts, f, indent=2)

    def all_used(self):
        return all(acc.get("used") for acc in self.accounts)
