from flask import Flask, render_template, request, redirect
import json
from modules.login_manager import LoginManager
from modules.target_queue import TargetQueue
from modules.reporter import Reporter

app = Flask(__name__)

login_manager = LoginManager('data/logins.json')
target_queue = TargetQueue('data/targets.json')
reporter = Reporter()

@app.route('/')
def dashboard():
    targets = target_queue.get_targets()
    accounts = login_manager.get_accounts()
    return render_template('dashboard.html', targets=targets, accounts=accounts)

@app.route('/start', methods=['POST'])
def start():
    while not login_manager.all_used():
        user = target_queue.get_next()
        if not user:
            break

        account = login_manager.get_next_account()
        if account:
            result = reporter.report(account, user)
            login_manager.mark_used(account)
            print(f"Reported {user} using {account['username']} - Status: {result}")

    print("All accounts used or all targets reported.")
    return redirect('/')

if __name__ == '__main__':
    app.run(debug=True)
