<?php
function log_failed_attempt($username, $password, $ip) {
    $timestamp = date('Y-m-d H:i:s');
    $logfile = 'login_log.json';

    $entry = [
        'timestamp' => $timestamp,
        'ip' => $ip,
        'username' => $username,
        'password' => $password,
        'status' => 'FAILED'
    ];

    if (!file_exists($logfile)) {
        file_put_contents($logfile, json_encode([$entry], JSON_PRETTY_PRINT));
    } else {
        $existing = json_decode(file_get_contents($logfile), true);
        $existing[] = $entry;
        file_put_contents($logfile, json_encode($existing, JSON_PRETTY_PRINT));
    }
}
?>
