<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: index.php');
    exit;
}

$logfile = 'login_log.json';
$log_entries = [];

if (file_exists($logfile)) {
    $content = file_get_contents($logfile);
    $log_entries = json_decode($content, true);
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Y.com Log Viewer</title>
    <link rel="stylesheet" href="style.css">
</head>
<body class="dashboard-body">
    <h1>Y.com | Login Attempts</h1>
    <p>Welcome, <?= htmlspecialchars($_SESSION['user']) ?>. Below are all failed login attempts.</p>
    <a href="logout.php">Logout</a>
    <table>
        <tr>
            <th>Timestamp</th>
            <th>IP Address</th>
            <th>Username</th>
            <th>Password</th>
            <th>Status</th>
        </tr>
        <?php foreach ($log_entries as $entry): ?>
            <tr>
                <td><?= htmlspecialchars($entry['timestamp']) ?></td>
                <td><?= htmlspecialchars($entry['ip']) ?></td>
                <td><?= htmlspecialchars($entry['username']) ?></td>
                <td><?= htmlspecialchars($entry['password']) ?></td>
                <td><?= htmlspecialchars($entry['status']) ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
