#!/bin/bash

echo "=== Jedi Chat Setup Script ==="

# Ensure required packages are installed
echo "[+] Installing Apache, PHP, and Unzip..."
apt update && apt install -y apache2 php unzip

# Set up directory
echo "[+] Setting up Jedi Chat directory..."
cd /var/www/html || exit
rm -rf jedi-chat
unzip jedi-chat-complete-final-inclusive.zip -d jedi-chat
chown -R www-data:www-data jedi-chat
chmod -R 755 jedi-chat

# Enable Apache and restart
echo "[+] Restarting Apache..."
systemctl enable apache2
systemctl restart apache2

echo "=== Setup Complete ==="
echo "Access Jedi Chat at http://<your-server-ip>/jedi-chat/"
