<?php
date_default_timezone_set("UTC");
$room = preg_replace("/[^a-zA-Z0-9_-]/", "", $_GET['room'] ?? 'lobby');
$usersFile = __DIR__ . "/messages/users-{$room}.json";
$expireSeconds = 10;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $user = htmlspecialchars(trim($input['user'] ?? 'Guest'));
    $now = time();

    $users = file_exists($usersFile) ? json_decode(file_get_contents($usersFile), true) : [];
    $users[$user] = $now;
    file_put_contents($usersFile, json_encode($users, JSON_PRETTY_PRINT));
    echo json_encode(['status' => 'ok']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $now = time();
    $users = file_exists($usersFile) ? json_decode(file_get_contents($usersFile), true) : [];
    $active = [];

    foreach ($users as $user => $ts) {
        if (($now - $ts) <= $expireSeconds) {
            $active[] = ['user' => $user, 'last' => date("H:i:s", $ts)];
        }
    }

    echo json_encode($active);
    exit;
}

http_response_code(405);
