<?php
date_default_timezone_set("UTC");
$room = preg_replace("/[^a-zA-Z0-9_-]/", "", $_GET['room'] ?? 'lobby');
$typingFile = __DIR__ . "/messages/typers-{$room}.json";
$expireSeconds = 5;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $user = htmlspecialchars(trim($input['user'] ?? 'Anonymous'));
    $now = time();

    $typers = file_exists($typingFile) ? json_decode(file_get_contents($typingFile), true) : [];
    $typers[$user] = $now;
    file_put_contents($typingFile, json_encode($typers, JSON_PRETTY_PRINT));
    echo json_encode(['status' => 'ok']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $now = time();
    $typers = file_exists($typingFile) ? json_decode(file_get_contents($typingFile), true) : [];
    $active = [];

    foreach ($typers as $user => $ts) {
        if (($now - $ts) <= $expireSeconds) {
            $active[] = $user;
        }
    }

    echo json_encode($active);
    exit;
}

http_response_code(405);
exit("Invalid request.");
