<?php
$roomsFile = __DIR__ . '/messages/rooms.json';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (file_exists($roomsFile)) {
        echo file_get_contents($roomsFile);
    } else {
        echo json_encode(["lobby"]);
    }
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents("php://input"), true);
    $newRoom = preg_replace("/[^a-zA-Z0-9_-]/", "", $input["room"] ?? "");
    if (!$newRoom) exit("No room name provided");

    $rooms = file_exists($roomsFile) ? json_decode(file_get_contents($roomsFile), true) : [];
    if (!in_array($newRoom, $rooms)) {
        $rooms[] = $newRoom;
        file_put_contents($roomsFile, json_encode($rooms, JSON_PRETTY_PRINT));
    }
    echo json_encode($rooms);
    exit;
}
http_response_code(405);
