<?php
date_default_timezone_set("UTC");

$user = htmlspecialchars($_POST['user'] ?? '');
$message = htmlspecialchars($_POST['message'] ?? '');
$room = preg_replace("/[^a-zA-Z0-9_-]/", "", $_POST['room'] ?? 'lobby');

$isDM = false;
$dmTarget = '';
if (preg_match("/^@([a-zA-Z0-9_-]+)/", $message, $matches)) {
    $isDM = true;
    $dmTarget = $matches[1];
    $room = 'dm-' . implode('-', array_unique([strtolower($user), strtolower($dmTarget)]));
}

$chatFile = __DIR__ . "/messages/{$room}.json";
$entry = ['user' => $user, 'message' => $message, 'time' => date("H:i:s")];

$messages = file_exists($chatFile) ? json_decode(file_get_contents($chatFile), true) : [];
$messages[] = $entry;
if (count($messages) > 100) $messages = array_slice($messages, -100);

file_put_contents($chatFile, json_encode($messages, JSON_PRETTY_PRINT));
echo json_encode(['status' => 'ok', 'room' => $room]);
