let username = "User" + Math.floor(Math.random() * 1000);
let room = new URLSearchParams(window.location.search).get("room") || "lobby";

window.onload = () => {
  document.getElementById("room-name").innerText = "#" + room;
  enableChatFallback();
  loadFileList();
};

function sendAjaxMessage() {
  const input = document.getElementById("message");
  const message = input.value.trim();
  if (!message) return;

  const isDM = message.startsWith("@");
  const data = { user: username, message, room };

  fetch("chat.php", {
    method: "POST",
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: new URLSearchParams(data)
  })
  .then(r => r.json())
  .then(resp => {
    if (resp.room && resp.room.startsWith("dm-")) {
      document.getElementById("room-name").innerText = "[DM] " + message.split(" ")[0];
    }
  });

  input.value = "";
}

function enableChatFallback() {
  setInterval(() => {
    fetch("chat.php?room=" + room)
      .then(res => res.json())
      .then(data => {
        const msgContainer = document.getElementById("messages");
        msgContainer.innerHTML = "";
        data.forEach(m => {
          addMessage(m.user, parseShortCodes(m.message), m.time);
        });
      });

    fetch("typing.php?room=" + room)
      .then(res => res.json())
      .then(data => {
        const el = document.getElementById("typing-indicator");
        el.innerText = data.length ? `${data.join(", ")} typing...` : "";
      });

    fetch("users.php?room=" + room, {
      method: "POST",
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ user: username })
    });

    fetch("users.php?room=" + room)
      .then(res => res.json())
      .then(users => {
        const panel = document.getElementById("user-list");
        if (!panel) return;
        panel.innerHTML = "<h3>Users Online</h3>";
        users.forEach(u => {
          const el = document.createElement("div");
          el.innerHTML = `${u.user} – <small>${u.last}</small>`;
          el.onclick = () => { document.getElementById("message").value = "@" + u.user + " "; };
          panel.appendChild(el);
        });
      });

  }, 5000);

  document.getElementById("message").addEventListener("keypress", (e) => {
    if (e.key === "Enter") sendAjaxMessage();
    else notifyTyping();
  });

  document.querySelector("button").onclick = sendAjaxMessage;
}

function addMessage(user, message, time = null) {
  const el = document.createElement("div");
  el.innerHTML = `<strong>[${time || new Date().toLocaleTimeString()}] ${user}:</strong> ${message}`;
  const msgContainer = document.getElementById("messages");
  msgContainer.appendChild(el);
  msgContainer.scrollTop = msgContainer.scrollHeight;
}

function sanitize(str) {
  return str.replace(/</g, "&lt;").replace(/>/g, "&gt;");
}

function parseShortCodes(msg) {
  if (msg.startsWith("@")) {
    const parts = msg.split(" ");
    return `<span style='color:#0ff;'>${parts[0]}</span> ` + sanitize(parts.slice(1).join(" "));
  }
  if (msg.startsWith("#file")) {
    return `<a href="/uploads/${msg.split("#file")[1]}" target="_blank">${msg}</a>`;
  }
  return sanitize(msg);
}

function notifyTyping() {
  fetch("typing.php?room=" + room, {
    method: "POST",
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ user: username })
  });
}

function loadFileList() {
  fetch("files/files.json")
    .then(res => res.json())
    .then(files => {
      const fileList = document.getElementById("file-list");
      fileList.innerHTML = "";
      files.reverse().forEach((file, i) => {
        const link = document.createElement("a");
        const short = `#file${i + 1}`;
        link.href = file.url;
        link.target = "_blank";
        link.textContent = `[${file.uploader}] ${file.filename} (${short})`;
        fileList.appendChild(link);
      });
    });
}

let currentDMTarget = null;
let dmPoller = null;

function openDM(targetUser) {
  currentDMTarget = targetUser;
  document.getElementById("dm-title").innerText = "DM with " + targetUser;
  document.getElementById("dm-panel").style.display = "block";
  document.getElementById("dm-input").value = "";

  loadDM();

  if (dmPoller) clearInterval(dmPoller);
  dmPoller = setInterval(loadDM, 3000);
}

function closeDM() {
  document.getElementById("dm-panel").style.display = "none";
  clearInterval(dmPoller);
}

function loadDM() {
  const names = [username.toLowerCase(), currentDMTarget.toLowerCase()].sort();
  const dmRoom = "dm-" + names.join("-");
  fetch("chat.php?room=" + dmRoom)
    .then(res => res.json())
    .then(messages => {
      const panel = document.getElementById("dm-messages");
      panel.innerHTML = "";
      messages.forEach(m => {
        const div = document.createElement("div");
        div.innerHTML = `<strong>${m.user}:</strong> ${parseShortCodes(m.message)}`;
        panel.appendChild(div);
      });
      panel.scrollTop = panel.scrollHeight;
    });
}

function sendDM() {
  const input = document.getElementById("dm-input");
  const message = input.value.trim();
  if (!message || !currentDMTarget) return;

  const payload = {
    user: username,
    message: "@" + currentDMTarget + " " + message,
    room: "lobby"  // starting point, PHP switches to DM file
  };

  fetch("chat.php", {
    method: "POST",
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: new URLSearchParams(payload)
  });

  input.value = "";
}
