import tkinter as tk
from tkinter import filedialog, messagebox
import threading
import random
import time
import subprocess
import os

user_agents = [
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.1 Safari/605.1.15",
    "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36",
    "Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko",
    "Mozilla/5.0 (iPhone; CPU iPhone OS 15_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.2 Mobile/15E148 Safari/604.1"
]

report_reasons = [
    "It's abusive or harmful",
    "They’re pretending to be me or someone else",
    "The account may be hacked",
    "It’s suspicious or spam",
    "It expresses intentions of self-harm or suicide"
]

class TwitterReporterUI:
    def __init__(self, master):
        self.master = master
        master.title("Twitter Mass Reporter UI")

        tk.Label(master, text="Accounts File:").grid(row=0, column=0, sticky=tk.W)
        self.accounts_entry = tk.Entry(master, width=50)
        self.accounts_entry.grid(row=0, column=1)
        tk.Button(master, text="Browse", command=self.load_accounts).grid(row=0, column=2)

        tk.Label(master, text="Proxies File:").grid(row=1, column=0, sticky=tk.W)
        self.proxies_entry = tk.Entry(master, width=50)
        self.proxies_entry.grid(row=1, column=1)
        tk.Button(master, text="Browse", command=self.load_proxies).grid(row=1, column=2)

        tk.Label(master, text="Target Username:").grid(row=2, column=0, sticky=tk.W)
        self.target_entry = tk.Entry(master, width=50)
        self.target_entry.grid(row=2, column=1)

        self.start_button = tk.Button(master, text="Start Reporting", command=self.start_reporting)
        self.start_button.grid(row=3, column=1, pady=10)

        self.status_text = tk.Text(master, height=15, width=80)
        self.status_text.grid(row=4, column=0, columnspan=3)

    def load_accounts(self):
        path = filedialog.askopenfilename()
        self.accounts_entry.delete(0, tk.END)
        self.accounts_entry.insert(0, path)

    def load_proxies(self):
        path = filedialog.askopenfilename()
        self.proxies_entry.delete(0, tk.END)
        self.proxies_entry.insert(0, path)

    def start_reporting(self):
        accounts_file = self.accounts_entry.get()
        proxies_file = self.proxies_entry.get()
        target = self.target_entry.get()

        if not all([accounts_file, proxies_file, target]):
            messagebox.showerror("Error", "Please fill out all fields.")
            return

        with open(accounts_file, "r") as f:
            accounts = [line.strip().split(":") for line in f if line.strip()]

        with open(proxies_file, "r") as f:
            proxies = [line.strip() for line in f if line.strip()]

        def run_reports():
            from selenium.webdriver.common.by import By
            from selenium.webdriver.common.keys import Keys
            import undetected_chromedriver.v2 as uc

            def log_status(msg):
                self.status_text.insert(tk.END, msg + "\n")
                self.status_text.see(tk.END)

            def setup_browser(proxy, user_agent):
                options = uc.ChromeOptions()
                if proxy:
                    options.add_argument(f'--proxy-server=http://{proxy}')
                if user_agent:
                    options.add_argument(f'user-agent={user_agent}')
                return uc.Chrome(options=options)

            for i, (username, password) in enumerate(accounts):
                proxy = proxies[i % len(proxies)]
                user_agent = random.choice(user_agents)
                reason = random.choice(report_reasons)
                try:
                    browser = setup_browser(proxy, user_agent)
                    browser.get("https://twitter.com/login")
                    time.sleep(random.uniform(3, 6))

                    user_input = browser.find_element(By.NAME, "text")
                    user_input.send_keys(username)
                    user_input.send_keys(Keys.RETURN)
                    time.sleep(random.uniform(2, 4))

                    pwd_input = browser.find_element(By.NAME, "password")
                    pwd_input.send_keys(password)
                    pwd_input.send_keys(Keys.RETURN)
                    time.sleep(random.uniform(5, 7))

                    browser.get(f"https://twitter.com/{target}")
                    time.sleep(random.uniform(3, 6))

                    browser.find_element(By.XPATH, "//div[@aria-label='More user actions']").click()
                    time.sleep(2)
                    browser.find_element(By.XPATH, "//span[text()='Report']").click()
                    time.sleep(2)
                    browser.find_element(By.XPATH, f"//span[text()='{reason}']").click()
                    time.sleep(2)
                    browser.find_element(By.XPATH, "//span[text()='Next']").click()
                    time.sleep(2)
                    browser.find_element(By.XPATH, "//span[text()='Submit']").click()
                    time.sleep(2)

                    log_status(f"{username}: Reported successfully with reason: {reason}")
                    browser.quit()
                except Exception as e:
                    log_status(f"{username}: Failed - {str(e)}")
                    try:
                        browser.quit()
                    except:
                        pass
                time.sleep(random.uniform(10, 20))

        threading.Thread(target=run_reports).start()

print("""
      ██████╗ ███████╗██████╗ ██╗███████╗███████╗██████╗ 
     ██╔════╝ ██╔════╝██╔══██╗██║██╔════╝██╔════╝██╔══██╗
     ██║  ███╗█████╗  ██████╔╝██║█████╗  █████╗  ██████╔╝
     ██║   ██║██╔══╝  ██╔═══╝ ██║██╔══╝  ██╔══╝  ██╔═══╝ 
     ╚██████╔╝███████╗██║     ██║███████╗███████╗██║     
      ╚═════╝ ╚══════╝╚═╝     ╚═╝╚══════╝╚══════╝╚═╝     
                JEDI SECURITY - TWITTER REPORTER
""")

if __name__ == "__main__":
    root = tk.Tk()
    app = TwitterReporterUI(root)
    root.mainloop()
