
import json
import os
from sentence_transformers import SentenceTransformer, util

# Load vector index metadata
metadata_file = os.path.join("sue_core", "sue_modules", "vector_metadata.json")
with open(metadata_file, "r") as f:
    metadata = json.load(f)

# Create a basic corpus of known summaries from metadata
corpus = [f"{item['title']}" for item in metadata]

# Initialize model
model = SentenceTransformer('all-MiniLM-L6-v2')
corpus_embeddings = model.encode(corpus, convert_to_tensor=True)

def assess_confidence(user_input):
    query_embedding = model.encode(user_input, convert_to_tensor=True)
    cosine_scores = util.cos_sim(query_embedding, corpus_embeddings)
    top_score = float(cosine_scores.max())

    print(f"Confidence Score: {top_score:.2f}")
    if top_score >= 0.70:
        print("Sue: I’m confident in this response.")
    elif 0.45 <= top_score < 0.70:
        print("Sue: This may contain speculative or inferred information.")
    else:
        print("Sue: This could be a hallucination. Verification recommended.")

if __name__ == "__main__":
    print("SUE Hallucination Filter Module")
    print("="*50)
    while True:
        query = input("\nEnter a response or topic for evaluation (or type 'exit'):\n> ")
        if query.lower() == "exit":
            break
        assess_confidence(query)
