
import os
import subprocess
import webbrowser

def clear_screen():
    os.system('cls' if os.name == 'nt' else 'clear')

def launch_module(path):
    subprocess.run(["python", path])

def main():
    clear_screen()
    print("="*50)
    print(" S.U.E. - Modular Dashboard Launcher ")
    print("="*50)
    print("1. Launch Oobabooga Web UI")
    print("2. Run RSS Feed Intelligence Module")
    print("3. Run Vector Memory Index (if installed)")
    print("4. Run Hallucination Filter (if installed)")
    print("5. Open News Index Folder")
    print("6. Exit")
    print("="*50)

    choice = input("Select an option: ").strip()

    if choice == "1":
        webbrowser.open("http://localhost:7860")
    elif choice == "2":
        launch_module("sue_core/sue_modules/sue_rss_feed_parser.py")
    elif choice == "3":
        launch_module("sue_core/sue_modules/sue_vector_memory.py")
    elif choice == "4":
        launch_module("sue_core/sue_modules/sue_hallucination_filter.py")
    elif choice == "5":
        os.startfile("sue_core/sue_modules/sue_news_index")
    elif choice == "6":
        print("Goodbye.")
        return
    else:
        print("Invalid selection.")

if __name__ == "__main__":
    main()
