import os
import subprocess
import sys

# Step 1: Create Virtual Environment
def create_virtualenv():
    print("[*] Creating virtual environment...")
    subprocess.run([sys.executable, "-m", "venv", "sue_env"])

# Step 2: Activate Virtual Environment and Install Requirements
def install_dependencies():
    print("[*] Installing core dependencies...")
    pip = os.path.join("sue_env", "Scripts", "pip.exe")
    subprocess.run([pip, "install", "--upgrade", "pip"])
    subprocess.run([pip, "install", "requests", "feedparser", "flask", "openai", "sentence-transformers", "faiss-cpu"])

# Step 3: Clone Oobabooga
def clone_oobabooga():
    if not os.path.exists("text-generation-webui"):
        print("[*] Cloning Oobabooga WebUI...")
        subprocess.run(["git", "clone", "https://github.com/oobabooga/text-generation-webui.git"])
    else:
        print("[*] Oobabooga already cloned.")

# Step 4: Create Project Directory Structure
def setup_directories():
    print("[*] Setting up directory structure...")
    os.makedirs("sue_modules/rss_processor", exist_ok=True)
    os.makedirs("sue_modules/vector_memory", exist_ok=True)
    os.makedirs("sue_modules/hallucination_filter", exist_ok=True)
    os.makedirs("sue_dashboard/avatar", exist_ok=True)
    os.makedirs("sue_dashboard/voice", exist_ok=True)

# Step 5: Summary
def summary():
    print("\n[+] SUE Core Setup Complete.")
    print("Next Steps:")
    print("- Download & place model files into 'text-generation-webui/models/'")
    print("- Configure RSS processor, memory, and GUI modules.")
    print("- Run Oobabooga with: cd text-generation-webui && python server.py")

# Run Installation
if __name__ == "__main__":
    create_virtualenv()
    install_dependencies()
    clone_oobabooga()
    setup_directories()
    summary()
