<?php
function getUserIP() {
    return $_SERVER['REMOTE_ADDR'];
}

function isSpamming($ip, $text) {
    $cooldown = 3; // seconds between messages
    $logFile = 'spamlog.json';

    $log = file_exists($logFile) ? json_decode(file_get_contents($logFile), true) : [];

    $now = time();
    if (!isset($log[$ip])) {
        $log[$ip] = ['last' => 0, 'last_msg' => ''];
    }

    $lastTime = $log[$ip]['last'];
    $lastMsg = $log[$ip]['last_msg'];

    if (($now - $lastTime) < $cooldown) return true;
    if ($lastMsg === $text) return true;

    $log[$ip] = ['last' => $now, 'last_msg' => $text];
    file_put_contents($logFile, json_encode($log, JSON_PRETTY_PRINT));
    return false;
}
