<?php
$file = 'userlist.json';
$timeout = 120; // seconds of activity before user is removed

$data = file_exists($file) ? json_decode(file_get_contents($file), true) : [];

$ip = $_SERVER['REMOTE_ADDR'];
$username = $_GET['user'] ?? '';
$now = time();

// Update user's last activity
if ($username) {
    $data[$ip] = ['user' => htmlspecialchars($username), 'time' => $now];
}

// Cleanup expired users
foreach ($data as $ipKey => $entry) {
    if ($entry['time'] < ($now - $timeout)) {
        unset($data[$ipKey]);
    }
}

file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
echo json_encode(array_values($data));
