<?php
include 'antispam.php';

$name = htmlspecialchars($_POST['name'] ?? '');
$text = htmlspecialchars($_POST['text'] ?? '');
$ip = getUserIP();

if (!$name || (!$text && empty($_FILES['file']))) {
    exit;
}

if (isSpamming($ip, $text)) {
    http_response_code(429);
    echo json_encode(["status" => "spam"]);
    exit;
}

$fileHTML = '';
if (!empty($_FILES['file']['name'])) {
    $filename = basename($_FILES['file']['name']);
    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));

    $disallowed = ['php', 'js', 'html', 'htm'];
    $images = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    $videos = ['mp4', 'webm'];
    $audios = ['mp3', 'ogg', 'wav'];
    $pdfs = ['pdf'];

    if (in_array($ext, $disallowed)) {
        exit;
    }

    $targetDir = "uploads/";
    if (!file_exists($targetDir)) mkdir($targetDir, 0755, true);
    $newName = uniqid() . "_" . preg_replace("/[^a-zA-Z0-9\._-]/", "_", $filename);
    $targetFile = $targetDir . $newName;

    if (move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)) {
        if (in_array($ext, $images)) {
            $fileHTML = "<br><img src='$targetFile' style='max-width:300px; max-height:200px; border:1px solid #00ff00;'>";
        } elseif (in_array($ext, $videos)) {
            $fileHTML = "<br><video src='$targetFile' controls style='max-width:300px; max-height:200px; border:1px solid #00ff00;'></video>";
        } elseif (in_array($ext, $audios)) {
            $fileHTML = "<br><audio controls src='$targetFile'></audio>";
        } elseif (in_array($ext, $pdfs)) {
            $fileHTML = "<br><a href='$targetFile' target='_blank' style='color:#00ff00;'>[PDF: $filename]</a>";
        } else {
            $fileHTML = "<br><a href='$targetFile' download style='color:#00ff00;'>[Download: $filename]</a>";
        }
    }
}

$msg = [
    'name' => $name,
    'text' => $text . $fileHTML,
    'time' => date('H:i:s')
];

$file = 'chatlog.json';
$chat = file_exists($file) ? json_decode(file_get_contents($file), true) : [];
$chat[] = $msg;
file_put_contents($file, json_encode(array_slice($chat, -100), JSON_PRETTY_PRINT));
