<?php
function fetchTags($url) {
    $html = @file_get_contents($url);
    if (!$html) return [];

    $doc = new DOMDocument();
    @$doc->loadHTML($html);
    $tags = [];

    foreach ($doc->getElementsByTagName('meta') as $meta) {
        $property = $meta->getAttribute('property') ?: $meta->getAttribute('name');
        $content = $meta->getAttribute('content');
        if ($property && $content) {
            $tags[$property] = $content;
        }
    }
    return $tags;
}

$url = $_GET['url'] ?? '';
if (!$url) exit;

// Create cache folder if it doesn't exist
$cacheDir = __DIR__ . '/.cache';
if (!file_exists($cacheDir)) mkdir($cacheDir, 0755, true);

// Generate cache key
$cacheKey = md5($url);
$cacheFile = "$cacheDir/$cacheKey.json";

// Auto-clean old cache files
foreach (glob("$cacheDir/*.json") as $f) {
    if (filemtime($f) < time() - 86400) unlink($f);
}

// Return cached data if it exists and is < 24h old
if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < 86400)) {
    echo file_get_contents($cacheFile);
    exit;
}

// Fetch metadata if not cached
$headers = @get_headers($url);
if (!$headers || strpos($headers[0], '200') === false) {
    echo json_encode(['error' => 'URL not reachable']);
    exit;
}

$tags = fetchTags($url);
$title = $tags['og:title'] ?? $tags['title'] ?? 'No Title';
$desc = $tags['og:description'] ?? $tags['description'] ?? '';
$image = $tags['og:image'] ?? '';

$data = json_encode([
    'title' => $title,
    'description' => $desc,
    'image' => $image,
    'url' => $url
]);

file_put_contents($cacheFile, $data);
echo $data;
