<?php
$ip = $_SERVER['REMOTE_ADDR'];
$ipListFile = 'iplist.json';
$limitPerIP = 3; // Max allowed connections per IP

// Initialize storage
$ipData = file_exists($ipListFile) ? json_decode(file_get_contents($ipListFile), true) : ['banned' => [], 'logins' => []];

// Check ban
if (in_array($ip, $ipData['banned'])) {
    http_response_code(403);
    echo json_encode(['error' => 'IP banned']);
    exit;
}

// Count logins
$ipData['logins'][$ip] = ($ipData['logins'][$ip] ?? 0) + 1;
if ($ipData['logins'][$ip] > $limitPerIP) {
    http_response_code(429);
    echo json_encode(['error' => 'Too many users from this IP']);
    exit;
}

// Save updated logins
file_put_contents($ipListFile, json_encode($ipData, JSON_PRETTY_PRINT));
echo json_encode(['status' => 'ok']);
