#!/bin/bash
echo "=== Installing Jedi Security Chat ==="

# Set destination directory
DEST_DIR="/var/www/html/jedi-chat"
mkdir -p $DEST_DIR

# Unzip chat files
unzip JediSecurityChat_Final.zip -d $DEST_DIR

# Set permissions
chmod -R 755 $DEST_DIR
chown -R www-data:www-data $DEST_DIR

# Setup .htaccess if Apache is used
cat <<EOF > $DEST_DIR/.htaccess
<FilesMatch "\.(php|json)$">
  Order deny,allow
  Allow from all
</FilesMatch>
EOF

echo "Installed at $DEST_DIR"
echo "Visit http://your-server-ip/jedi-chat to use Jedi Security Chat"
