<!DOCTYPE html><html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>SUE v2 | Interface Prototype</title>
  <style>
    html, body {
      margin: 0;
      padding: 0;
      background-color: #000;
      color: #00ffcc;
      font-family: 'Courier New', monospace;
      height: 100vh;
      overflow: hidden;
    }canvas#matrix {
  position: fixed;
  top: 0; left: 0;
  z-index: 0;
}

#ui-shell {
  position: relative;
  z-index: 1;
  padding: 20px;
}

#sue-avatar {
  float: right;
  width: 150px;
  height: 150px;
  border-radius: 50%;
  border: 2px solid #00ffcc;
  background: url('https://placehold.co/150x150/000000/00ffcc?text=SUE') center/cover;
  box-shadow: 0 0 10px #00ffcc;
}

#terminal {
  background-color: rgba(0, 0, 0, 0.75);
  border: 1px solid #00ffcc;
  padding: 20px;
  height: 300px;
  overflow-y: auto;
  font-size: 14px;
}

#input-area {
  margin-top: 10px;
}

input[type="text"] {
  width: 100%;
  padding: 10px;
  background: #111;
  border: 1px solid #00ffcc;
  color: #00ffcc;
  font-size: 16px;
}

  </style>
</head>
<body>
  <canvas id="matrix"></canvas>
  <div id="ui-shell">
    <div id="sue-avatar"></div>
    <h1>SUE v2 Interface</h1>
    <div id="terminal">
      <p>[SUE]: Hello, Josh. Ready for today's ops? 🖤</p>
    </div>
    <div id="input-area">
      <input type="text" id="userInput" placeholder="Type a command or question...">
    </div>
  </div>  <script>
    // Matrix Background
    const canvas = document.getElementById("matrix");
    const ctx = canvas.getContext("2d");

    canvas.height = window.innerHeight;
    canvas.width = window.innerWidth;

    let letters = Array(256).join("1").split("");

    const draw = () => {
      ctx.fillStyle = "rgba(0, 0, 0, 0.05)";
      ctx.fillRect(0, 0, canvas.width, canvas.height);
      ctx.fillStyle = "#00ffcc";

      letters.map((y_pos, index) => {
        const text = String.fromCharCode(3e4 + Math.random() * 33);
        const x_pos = index * 10;
        ctx.fillText(text, x_pos, y_pos);

        letters[index] = y_pos > canvas.height + Math.random() * 1e4 ? 0 : y_pos + 10;
      });
    };

    setInterval(draw, 33);

    // Input handling
    const input = document.getElementById('userInput');
    const terminal = document.getElementById('terminal');

    input.addEventListener("keypress", function(e) {
      if (e.key === "Enter") {
        const cmd = input.value;
        terminal.innerHTML += `<p>> ${cmd}</p>`;
        terminal.innerHTML += `<p>[SUE]: Processing "${cmd}"...</p>`;
        terminal.scrollTop = terminal.scrollHeight;
        input.value = "";
      }
    });
  </script></body>
</html>